<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class ProcessExecutionStep extends Model 
{

    protected $table = 'process_execution_steps';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('user_id', 'process_execution_id', 'process_step_version_id', 'process_step_version_actions', 'data', 'start_date', 'end_date', 'deadline_date', 'actions_count', 'done_actions_count', 'status');

    public function user()
    {
        return $this->belongsTo('App\Models\User');
    }

    public function processExecution()
    {
        return $this->belongsTo('App\Models\ProcessExecution');
    }

}